 ; Ŀ
 ;   Move entities to another layer by selecting an object thereon.        
 ;   Copyright 1990, 2006 by Rocket Software Ltd.                          
 ;   Why are you reading this?  Don't you have work to do?                 
 ; 

 ; Ŀ
 ;   Blolt - Call a dialog box, get a layer name.                          
 ;   Arguments: None.                                                      
 ;   Calls every subroutine in this file (except itself), rewrites the     
 ;   dialog box on the fly.  Returns a name.                               
 ; 
 (DEFUN BLOLT (/ malist htnum widnum)
 ; Ŀ
 ;   Get a list of all non-xref blocks.                                    
 ; 
  (setq malist (laxi))
 ; Ŀ
 ;   Put the list in order.                                                
 ; 
  (setq malist (acad_strlsort malist))
 ; Ŀ
 ;   Get the list length and maximum string length, call Drosop to         
 ;   rewrite the .dcl file to reflect these numbers.                       
 ; 
  (setq htnum (length malist))
  (setq widnum (lsdata malist))
  (drosop "lch.dcl" widnum htnum)
 ; Ŀ
 ;   And call the dialog box to get a layer name.                          
 ; 
  (lbox malist "lch.dcl" "lch" "Layers." "Destination Layer"))
 ; Ŀ
 ;   Blolt end.                                                            
 ; 

 ; Ŀ
 ;   Drosop - rewrite a dcl file on the fly.                               
 ;   Arguments: Filnam, a dcl file name.                                   
 ;              Widnum, the desired dialog box width.                      
 ;              Htnum, the desired dialog box height.                      
 ;   Calls Yout, Word1, and Pout.  Returns nothing.                        
 ; 
 (DEFUN DROSOP (filnam widnum htnum / comlst num sub gnulst)
 ; Ŀ
 ;   The dialog box height is greater than the list length.                
 ; 
  (setq htnum (+ htnum 3)) ; for bottom lines plus one space
 ; Ŀ
 ;   The dialog box can't be bigger than the screen.                       
 ; 
  (cond ((< widnum 24)
         (setq widnum 24))
        ((> widnum 165)
         (setq widnum 165)))   ; maximum width is 165 (on 1024 x 768)
  (cond ((< htnum 10)
         (setq htnum 10))
        ((> htnum 50)
         (setq htnum 50)))     ; maximum height is 50 (on 1024 x 768)
 ; Ŀ
 ;   Open, read, modify and rewrite the file.                              
 ; 
  (setq filnam (findfile "lch.dcl"))
  (setq comlst (yout filnam))
  (setq num 0)
  (while (setq sub (nth num comlst))
         (setq num (1+ num))
         (cond ((= (word1 sub) "width")
                (setq sub (strcat "                 width = "
                                  (itoa widnum) ";")))
               ((= (word1 sub) "height")
                (setq sub (strcat "                 height = "
                                  (itoa htnum) ";}"))))
         (setq gnulst (append gnulst (list sub))))
  (pout gnulst filnam)
 (princ))
 ; Ŀ
 ;   Drosop end.                                                           
 ; 

 ; Ŀ
 ;   Isxlay - see if a layer belongs to an xref - i.e. if the name         
 ;   passed as the sole argument contains a |.                             
 ;   Returns T if so, otherwise nil.                                       
 ; 
 (DEFUN ISXLAY (str / pos sub foundx)
  (setq pos 1)
  (while (and (null foundx) (setq sub (substr str pos 1)) (/= sub ""))
         (if (= sub "|")
             (setq foundx t)
             (setq pos (1+ pos))))
 foundx)
 ; Ŀ
 ;   Isxlay end.                                                           
 ; 

 ; Ŀ
 ;   Laxi - get a list of all non-Xref layers in the drawing.              
 ;   Takes no arguments, calls nothing, returns a list.                    
 ; 
 (DEFUN LAXI (/ rew nexb namm blist)
  (setq rew T)
  (while (setq nexb (tblnext "layer" rew))
         (setq rew ())
         (setq namm (cdr (assoc 2 nexb)))
         (if (null (isxlay namm))
             (setq blist (cons namm blist))))
 blist)
 ; Ŀ
 ;   Laxi end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lbox - display a list of strings in a dialog box.          
 ;   Arguments: Styldt, the list of strings to display.                    
 ;              Dclfil, the dcl file name.                                 
 ;              Dclnam, the dialog box name in the dcl file.               
 ;              Prom, the type for the number of things found prompt.      
 ;              Dianam, the dialog box title.                              
 ;   Returns a text string or nil.                                         
 ; 
 (DEFUN LBOX (styldt dclfil dclnam prom dianam / fpath dcl_id num numf filnam
                                                       fnam malist findx ret)
  (setq dcl_id (load_dialog dclfil))
  (new_dialog dclnam dcl_id)      ; must come before data for list box
  (set_tile "diabox" dianam)
 ; Ŀ
 ;   Make the Style list for the list box.                                 
 ; 
  (start_list "the_list")         ; read ltype data list into list box
  (setq num 0)
  (while (setq stylnm (nth num styldt))
         (add_list stylnm)
         (setq malist (cons stylnm malist))
         (setq num (1+ num)))
  (end_list)
  (setq malist (reverse malist))
  (set_tile "babtext" (strcat (itoa num) " " prom))
 ; Ŀ
 ;   Actions for given buttons/selections.  Must come after New_dialog     
 ;   call and before Start_dialog.                                         
 ; 
  (action_tile "select_ok" "(setq findx (selok $reason))")
  (action_tile "the_list" "(setq findx (lisok $reason))")
  (action_tile "fcancel" "(setq findx ())")
 ; Ŀ
 ;   Run it.                                                               
 ; 
  (setq ret (start_dialog))
  (unload_dialog dcl_id)
 ; Ŀ
 ;   Return a text string or nil.                                          
 ; 
 (if (and findx (/= findx ""))
     (nth (read findx) malist) nil))
 ; Ŀ
 ;   Lbox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Lisok - if the list box generated a callback, see if it    
 ;   was a double click or an Enter, in which case return the value of     
 ;   the tile and close the dialog box.                                    
 ; 
 (DEFUN LISOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (= reason 4)
      (done_dialog)
      (set_tile "babtext" ""))
 lisval)
 ; Ŀ
 ;   Lisok end.                                                            
 ; 

 ; Ŀ
 ;   Lsdata - get the maximum string length in a list of strings.          
 ;   Arguments: Lista, a list.                                             
 ;   Calls nothing, returns a number (0 if there were no strings.)         
 ; 
 (DEFUN LSDATA (lista / num maxa sub len)
  (setq num 0)
  (setq maxa 0)
  (while (setq sub (nth num lista))
         (setq num (1+ num))
         (if (and (= (type sub) 'STR)
                  (> (setq len (strlen sub)) maxa))
             (setq maxa len)))
 maxa)
 ; Ŀ
 ;   Lsdata end.                                                           
 ; 

 ; Ŀ
 ;   Pout - write a list of strings to a file.                             
 ;   Arguments: Lista, a list.                                             
 ;              Filnam, a filename.                                        
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN POUT (lista filnam / fn sub)
  (setq fn (open filnam "w"))
  (while (setq sub (car lista))
         (setq lista (cdr lista))
         (write-line sub fn))
  (close fn)
 (princ))
 ; Ŀ
 ;   Pout end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Selok - if OK was pressed, see if a file name was          
 ;   selected, if so exit the dialog box and return the zero based index   
 ;   of that name.  Otherwise show an error.                               
 ; 
 (DEFUN SELOK (reason / lisval)
  (setq lisval (get_tile "the_list"))
  (if (and lisval (/= lisval ""))
      (done_dialog)
      (set_tile "babtext" "You must select a name."))
 lisval)
 ; Ŀ
 ;   Selok end.                                                            
 ; 

 ; Ŀ
 ;   Word1 - get the first word in a string.                               
 ;   Arguments: Str, a string.                                             
 ;   Calls nothing, returns a word or "".                                  
 ; 
 (DEFUN WORD1 (str / pos chra)
  (while (= (substr str 1 1) " ")
         (setq str (substr str 2)))
  (setq pos 1)
  (while (and (/= (setq chra (substr str pos 1)) "")
              (/= chra " "))
         (setq pos (1+ pos)))
  (cond ((= (substr str pos 1) " ")
         (setq str (substr str 1 (1- pos))))
        (t
         (setq str (substr str 1 pos)))))
 ; Ŀ
 ;   Word1 end.                                                            
 ; 

 ; Ŀ
 ;   Yout - suck a text file into a list.                                  
 ;   Arguments: filnam, a filename.                                        
 ;   Returns a list of strings.                                            
 ; 
 (DEFUN YOUT (filnam / fn linn malist)
  (if (setq fn (open filnam "r"))
      (progn
           (while (setq linn (read-line fn))
                  (setq malist (append malist (list linn))))
           (close fn)))
 malist)
 ; Ŀ
 ;   Yout end.                                                             
 ; 

 ; Ŀ
 ;   Lch.                                                                  
 ; 
 (DEFUN C:LCH (/ snapp tt zz ss num aa obj xx)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Get some things to re-layer.                                          
 ; 
   (write-line "Pick objects to re-layer:")
   (if (setq ss (ssget))
 ; Ŀ
 ;   Get a layer name from a selected entity or from a dialog box.         
 ; 
       (if (setq tt (entsel "Pick something on the desired layer or <List>:"))
           (setq zz (cdr (assoc 8 (entget (car tt)))))
           (setq zz (blolt))))
   (cond ((and ss zz)
          (setq num 0)
          (while (setq aa (ssname ss num))
                 (setq obj (entget aa))
                 (setq xx (assoc 8 obj))
                 (entmod (subst (cons 8 zz) xx obj))
                 (setq num (1+ num)))
          (if (= num 1)
              (setq tt " item ") (setq tt " artifacts "))
          (write-line (strcat "\n" (itoa num) tt 
                              "moved from layer " (cdr xx)
                              " to layer " zz ".")))
         ((null ss)
          (write-line "No entities selected."))
         ((null zz)
          (write-line "No destination layer.")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))